#!/bin/bash

. `dirname $0`/rrd_conf.ini
#start=`date +%s`

#Создаем базу  
#для версий астриска 1.6* можно использовать счетчик астериска (DS:DERIVE)
create_db () {
    rrdtool create $RRDB -s 60 \
    DS:la1min:GAUGE:120:0:U \
    DS:la5min:GAUGE:120:0:U \
    DS:la15min:GAUGE:120:0:U \
    DS:ast_datacalls:GAUGE:120:0:U \
    DS:memused:GAUGE:120:0:U \
    DS:mem_used_asterisk:GAUGE:120:0:U \
    DS:mem_used_httpd:GAUGE:120:0:U \
    DS:mem_used_mysqld:GAUGE:120:0:U \
    DS:cpu_used_asterisk:GAUGE:120:0:U \
    DS:cpu_used_httpd:GAUGE:120:0:U \
    DS:cpu_used_mysqld:GAUGE:120:0:U \
    RRA:AVERAGE:0.5:1:60 \
    RRA:MAX:0.5:1:60 \
    RRA:LAST:0.5:1:60 \
    RRA:AVERAGE:0.5:3:60 \
    RRA:MAX:0.5:3:60 \
    RRA:LAST:0.5:3:60 \
    RRA:AVERAGE:0.5:10:72 \
    RRA:MAX:0.5:10:72 \
    RRA:LAST:0.5:10:72 \
    RRA:AVERAGE:0.5:60:744 \
    RRA:MAX:0.5:10:744 \
    RRA:LAST:0.5:10:744 \
    RRA:AVERAGE:0.5:288:1825 \
    RRA:MAX:0.5:288:1825 \
    RRA:LAST:0.5:288:1825
}

#Если используется ssh  , то все команды описываются  в $RUN .
# Если SSHCONNECT не определена , то выполняется bash -c "$RUN"
#Сделано для быстрого сбора данных , через одно подключение
load_data_one_ssh () {
    if [ ! -f $RRDB ]; then
	echo "No database $RRDB"
	echo "Creating......$RRDB"
    	mkdir -p "`dirname $RRDB`"
	create_db || exit 2
	echo "Database was created"
    fi

    RUN="
    uptime | sed -e 's/, /:/g' | sed 's/^.*load average\: //g'
    #для типа DS:ast_datacalls:GAUGE
    ($ASTERISKBIN -rx 'core show calls' || echo 0 active calls) | awk '/active calls/ {print \$1}'
    #для типа DS:ast_datacalls:DERIVE
    #($ASTERISKBIN -rx 'core show channels' || echo 0 calls processed) | grep 'processed' | sed 's/\ call.*//g'
    #free -m | grep 'buffers/cache' | sed 's/^.*buffers\/cache\://g' | awk '{print \$1}' | sed 's/,/./g'
    ps -e -o rss | awk '{a+=\$1} END {print a/1024}' | sed 's/,/./g'
    get_pid () {
        find /var/run/ -name "\$1.pid" -exec cat {} \;
    }
    get_mem_used () {
        (ps -p \$1 --ppid \$1 -o rss 2>/dev/null ||echo 0) | awk '{m+=\$1} END {print m/1024}' | sed 's/,/./g'
    }
    get_cpu_used () {
        (ps -p \$1 --ppid \$1 -o %cpu 2>/dev/null ||echo 0) | awk '{c+=\$1} END {print c}' | sed 's/,/./g'
    }
    get_cpu_used \`get_pid asterisk\` 
    if [ \`whereis httpd | awk '{print \$2}'\` ] ; then
        get_cpu_used \`get_pid httpd\`
    else
        get_cpu_used \`get_pid apache2\`
    fi
    get_cpu_used \`get_pid mysqld\` 
    get_mem_used \`get_pid asterisk\` 
    if [ \`whereis httpd | awk '{print \$2}'\` ] ; then
        get_mem_used \`get_pid httpd\` 
    else 
        get_mem_used \`get_pid apache2\` 
    fi
    get_mem_used \`get_pid mysqld\` || echo 0
    "
    s=""
    for i in `${SSHCONNECT:-$SHELL_EXEC} "$RUN"`
    do
        s+="$i:"
    done
    $RRDTOOL update $RRDB -t \
    "la1min:la5min:la15min:ast_datacalls:memused:cpu_used_asterisk:cpu_used_httpd:cpu_used_mysqld:mem_used_asterisk:mem_used_httpd:mem_used_mysqld" \
    N:${s%:}
}

#Проверка опций 
#Рабочая папка определяется в $BASEDIR
if [ -z $BASEDIR ] ; then BASEDIR='./' ; fi

while getopts i:d:h:u: opts; do
    case $opts in
        d) RRDB=$BASEDIR/$OPTARG.rrd;;
        h) HOST=$OPTARG;;
        i) IDENTIFY_FILE=$OPTARG;; 
        u) USER=$OPTARG;;
        ?) echo "Usage -d database -h host"
           exit 2;;
    esac
done

if [ $# -eq 0 ] ; then
    echo "Usage `pwd`/`basename $0` -dh"
    echo "-d: RR database name without .rrd"
    echo "-h: host for collect data"
    echo "-u: username for SSH"
    echo "-i: indentify file for  ssh key for remote host"
else
#для переменной окружения  есть $USER , так что если не использовать -u , то юзер будет , запускающий скрипт

    if [ ! -z $HOST ] && [ ! -z $USER ] ; then SSHCONNECT="ssh -l $USER $HOST -i $IDENTIFY_FILE" ; fi 
    if [ -z $RRDB ] ; then echo "Need name fot database file *.rrd" ; exit 2 ; fi
    load_data_one_ssh 
fi
#проверка быстродействия 
#echo "Время выполнения $[`date +%s` - $start ]"
#echo ${s%:} 
