#!/bin/bash

. `dirname $0`/rrd_conf.ini

graph_this () {
    SAVEDIR=$GRAPHDIR
    if [ ! -d $SAVEDIR ] ; then
        mkdir -p $SAVEDIR
    fi 
    CUT_TIME="-s "${start:-e-1hour}" -e "${endtime:-now}""
    $RRDTOOL graph $SAVEDIR/$AST_CALLS_PIC  $CUT_TIME \
        DEF:ast_datacalls=$RRDB:ast_datacalls:MAX \
        CDEF:ast_percent=ast_datacalls,1,* \
        AREA:ast_percent#FF9933:"" \
        COMMENT:"\n" \
 	GPRINT:ast_percent:MAX:"Максимум\: %0.0lf\n" \
    GPRINT:ast_percent:AVERAGE:"Среднее значение\: %0.0lf" \
        -v "звонки" -t "Загрузка Asterisk" \
        $COLORS -Y ${GRAPHOPTIONS/ --slope-mode} $FONT ; echo $SAVEDIR/$AST_CALLS_PIC
    $RRDTOOL graph $SAVEDIR/$LOAD_AV_PIC  $CUT_TIME \
        DEF:la1min=$RRDB:la1min:MAX \
        AREA:la1min#3366FF:"" \
        COMMENT:"\n" \
        GPRINT:la1min:MAX:"Максимум\: %0.1lf\n"  \
        GPRINT:la1min:AVERAGE:"Среднее значение\: %0.1lf"  \
        -v "Load Average" -t "Загрузка системы" \
        $COLORS $GRAPHOPTIONS $FONT ; echo $SAVEDIR/$LOAD_AV_PIC
    $RRDTOOL graph $SAVEDIR/$MEMUSED_PIC $CUT_TIME \
        DEF:memused=$RRDB:memused:MAX \
        AREA:memused#339933:"" \
        COMMENT:"\n" \
        GPRINT:memused:MAX:"Максимум\: %0.2lf Mb\n"  \
        GPRINT:memused:AVERAGE:"Среднее значение\: %0.2lf Mb"  \
        -v "Mb" -t "Использование RAM"  \
        $COLORS --upper-limit ${MEM_ALL:-0} $GRAPHOPTIONS $FONT ; echo $SAVEDIR/$MEMUSED_PIC
    $RRDTOOL graph $SAVEDIR/$CPU_ASTWEBMYSQL_PIC  $CUT_TIME \
        DEF:cpu_used_asterisk=$RRDB:cpu_used_asterisk:MAX \
        DEF:cpu_used_httpd=$RRDB:cpu_used_httpd:MAX \
        DEF:cpu_used_mysqld=$RRDB:cpu_used_mysqld:MAX \
        LINE1:cpu_used_asterisk#FF9933:"Asterisk \t" \
        GPRINT:cpu_used_asterisk:AVERAGE:"%0.1lf %% \n" \
        LINE1:cpu_used_httpd#FF3300:"Apache \t" \
        GPRINT:cpu_used_httpd:AVERAGE:"%0.1lf %% \n" \
        LINE1:cpu_used_mysqld#666666:"MySQL \t" \
        GPRINT:cpu_used_mysqld:AVERAGE:"%0.1lf %% \n" \
        -v "проценты" -t "Загрузка CPU процессами" \
        $COLORS $GRAPHOPTIONS $FONT ;echo $SAVEDIR/$CPU_ASTWEBMYSQL_PIC
    $RRDTOOL graph $SAVEDIR/$RAM__ASTWEBMYSQL_PIC  $CUT_TIME \
        DEF:ram_used_asterisk=$RRDB:mem_used_asterisk:MAX \
        DEF:ram_used_httpd=$RRDB:mem_used_httpd:MAX \
        DEF:ram_used_mysqld=$RRDB:mem_used_mysqld:MAX \
        LINE1:ram_used_asterisk#FF9933:"Asterisk \t" \
        GPRINT:ram_used_asterisk:AVERAGE:"%0.1lf Mb \n" \
        LINE1:ram_used_httpd#FF3300:"Apache \t" \
        GPRINT:ram_used_httpd:AVERAGE:"%0.1lf Mb \n" \
        LINE1:ram_used_mysqld#666666:"MySQL \t" \
        GPRINT:ram_used_mysqld:AVERAGE:"%0.1lf Mb \n" \
        -v "Mb"  -t "Использование RAM процессами" \
        $COLORS $GRAPHOPTIONS $FONT ; echo $SAVEDIR/$RAM__ASTWEBMYSQL_PIC
     $RRDTOOL graph $SAVEDIR/$LA_AST_PIC  $CUT_TIME \
        DEF:la1min=$RRDB:la1min:MAX \
        DEF:ast_datacalls=$RRDB:ast_datacalls:MAX \
        CDEF:ast_percent=ast_datacalls,1,* \
        CDEF:la_percent=la1min,10,* \
        LINE1:ast_percent#FF9933:"Кол-во каналов Asterisk\n" \
        LINE1:la_percent#3366FF:"Load Average*10\n" \
        COMMENT:"\s" \
        COMMENT:"\s" \
        -v "звонки" -t "Asterisk и загрузка системы" \
        $COLORS -Y $GRAPHOPTIONS $FONT ; echo $SAVEDIR/$LA_AST_PIC
}



while getopts d:D:s:e: opts; do 
    case $opts in
        D) GRAPHDIR=$OPTARG;; 
        d) RRDB=$BASEDIR/$OPTARG.rrd;;
        s) start=`date -d "$OPTARG" +%s 2>/dev/null` || start=$OPTARG;; 
        e) endtime=`date -d "$OPTARG" +%s` || (echo 'need date format YYYY-MM-DD [hh:mm]';exit 0) ;; 
        ?) echo "Usage -dDse" 
           exit 2;;
    esac
done
if [ $# -eq 0 ] ; then
    echo "Usage `pwd`/`basename $0` -nDs" 
    echo "-D: directory,"
    echo "-d: RR database .rrd"
    echo "-s: start time in format YYYY-MM-DD [hh:mm]"
    echo "-e: end time in format YYYY-MM-DD [hh:mm]"
    echo "if enter without -s and -e then prints graphs from now time-1hour to nowtime"
    echo "may enter -s without -e , entering '-1hour', '-2day', that mean grphs 'll be nowtime to -s option"
else
if [ -z $RRDB ] ; then echo "Need database file *.rrd" ; exit 2 ; fi
if [ -z $GRAPHDIR ] ; then GRAPHDIR="$BASEDIR/charts" ; fi
	rm -f $GRAPHDIR/*.png
    graph_this $start $endtime || echo "error in date" 
    echo RRDB=$RRDB
    echo GRAPHDIR=$GRAPHDIR
fi
